<?php defined('SYSPATH') or die('No direct script access.');

class Task_Sub_Checker_Ebay extends Minion_Task {

    $cookie_file_path = "/tmp/cookies.txt";
    $userAgent = "Nokia-Communicator-WWW-Browser/2.0 (Geos 3.0 Nokia-9000i)";

    protected function _execute(array $params){
        Task_Helper::createWorker('Sub:Checker:Ebay', $this);
        // helper or simple example
//        $worker = new GearmanWorker();
//        $worker->addServer('127.0.0.1', 4730);
//        $worker->addFunction('Sub:Checker:Ebay', [$this, 'Worker']);
//        $worker->work();
    }

    /**
     *  @param GearmanJob $job->workload()
     *    $params = [
     *      'client' => (string)
     *      'login'  => (string)
     *      'pass'   => (string)
     *    ]
     **/
    public function Worker(GearmanJob $job){
        $data = json_decode($job->workload(), true);

        $balance = $this->checkAccount($data['login'], $data['pass']);

        if($balance)
            $this->setComment($client, "Balance: $balance");
    }

    private function setComment($client, $comment){
        /* ... */
    }


    private function checkAccount($userid, $pass)
    {
        $ch = curl_init();

        $headers[] = "Accept: */*";
        $headers[] = "Connection: Keep-Alive";

        curl_setopt($ch, CURLOPT_HTTPHEADER,  $headers);
        curl_setopt($ch, CURLOPT_HEADER,  0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  
        curl_setopt($ch, CURLOPT_USERAGENT, $this->userAgent); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
        curl_setopt($ch, CURLOPT_COOKIEFILE, $this->cookie_file_path); 
        curl_setopt($ch, CURLOPT_COOKIEJAR, $this->cookie_file_path); 
        curl_setopt($ch, CURLOPT_COOKIESESSION, TRUE);
        curl_setopt($ch, CURLOPT_REFERER, "https://www.ebay.com/");

        // set first URL
        curl_setopt($ch, CURLOPT_URL, "https://www.ebay.com/signin/s");
        $content = curl_exec($ch);


        $fields = get_input_tags($content);

        $fields['userid'] = $userid;
        $fields['pass'] = $pass;

        $POSTFIELDS = http_build_query($fields); 

        curl_setopt($ch, CURLOPT_URL, $LOGINURL); 
        curl_setopt($ch, CURLOPT_POST, 1); 
        curl_setopt($ch, CURLOPT_POSTFIELDS, $POSTFIELDS);
        curl_exec($ch);  


        curl_setopt($ch, CURLOPT_URL, 'https://my.ebay.com/ws/eBayISAPI.dll?MyEbayBeta&CurrentPage=MyeBayNextSellerAccounts&ssPageName=STRK:ME:LNLK&gbh=1');
        curl_setopt($ch, CURLOPT_COOKIEJAR, $this->cookie_file_path); 
        curl_setopt($ch, CURLOPT_COOKIEFILE, $this->cookie_file_path);
        curl_setopt($ch, CURLOPT_COOKIESESSION, TRUE);
        curl_setopt($ch, CURLOPT_REFERER, "https://www.ebay.com/");
        curl_setopt($ch, CURLOPT_POST, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER,  $headers);
        curl_setopt($ch, CURLOPT_HEADER,  0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  
        curl_setopt($ch, CURLOPT_USERAGENT, $this->userAgent); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
        $result = curl_exec($ch);

        $balance = false;

        if (stripos($result, 'Current Balance:</td>') !== false)
        {
            $dom = new DOMDocument();
            $dom->loadHTML($result);
            $xpath = new DOMXPath($dom);

            
            $balance = $xpath->query('//td[@class="AccountSummary_acctsumtab_row6col2"]')->item(0)->nodeValue;
        }

        return $balance;
    }

    private function getInputTags($html)
    {
        $post_data = array();

        $dom = new DomDocument;
        $dom->loadHTML($html);
        $dom->preserveWhiteSpace = false;

        $input_tags = $dom->getElementsByTagName('input');

        for($i = 0; $i < $input_tags->length; $i++)
        {
            if(is_object($input_tags->item($i)))
            {
                $name = $value = '';
                $name_o = $input_tags->item($i)->attributes->getNamedItem('name');

                if(is_object($name_o))
                {
                    $name = $name_o->value;
                    $value_o = $input_tags->item($i)->attributes->getNamedItem('value');

                    if(is_object($value_o))
                    {
                        $value = $input_tags->item($i)->attributes->getNamedItem('value')->value;
                    }

                    $post_data[$name] = $value;
                }
            }
        }

        return $post_data;
    }
}
